Rem  Copyright (c) 1998 by Oracle Corporation 
Rem    NAME
Rem     WordSolution.sql - APIs to enables Oracle callouts to Word Automation Server
Rem    DESCRIPTION
REM		Demonstrate Oracle Database callouts using the COMCartridge to Microsoft Word application
REM		Expose a set of calls to
REM		1. create a Word document
REM		2. Insert Text
REM		3. Format Font size
REM		4. Save the Word file
REM		5. Quit Word
REM
Rem    MODIFIED   (MM/DD/YY)
Rem     kfleong	   01/12/98 -  Creation
REM
REM	
drop package ORDWord; 
/
CREATE PACKAGE ORDWord AS


   /* Declare externally callable subprograms. */
   
	FUNCTION CreateWordObject(servername varchar2) return binary_integer; 

	FUNCTION FileNew return binary_integer;

	FUNCTION FileLoad(filename varchar2) return binary_integer;

	FUNCTION FileSave return binary_integer;

	FUNCTION FileSaveAs(filename varchar2) return binary_integer;

	FUNCTION FileClose return binary_integer;

	FUNCTION InsertText(textstr varchar2) return binary_integer;

	FUNCTION InsertNewLine return binary_integer;

	FUNCTION FormatFontSize(fontsize binary_integer) return binary_integer;

END ORDWord;
/
CREATE PACKAGE BODY ORDWord AS

   DummyToken		binary_integer;	
   applicationToken binary_integer:=-1;
   i				binary_integer;


error_src varchar2(255);
error_description varchar2(255);
error_helpfile varchar2(255);
error_helpID binary_integer;

/***************************************************************************
 * Invoke the Excel Automation Server and create a Workbook object as 
 * well as a worksheet object
 ***************************************************************************/
FUNCTION CreateWordObject(servername varchar2)  return binary_integer IS
BEGIN
	dbms_output.put_line('Creating Word application...');
	i:=ORDCOM.CreateObject('Word.Basic', 0, servername,applicationToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END CreateWordObject;


FUNCTION FileNew return binary_integer IS
BEGIN
	ORDCOM.InitArg();
	dbms_output.put_line('Creating new File....');
	i:=ORDCOM.Invoke(applicationToken, 'FileNewDefault', 0, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END FileNew;

FUNCTION FileLoad(filename varchar2) return binary_integer IS
BEGIN
	ORDCOM.InitArg();
	ORDCOM.SetArg(filename, 'BSTR');
	dbms_output.put_line('Loading file...');
	i:=ORDCOM.Invoke(applicationToken, 'FileOpen', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END FileLoad;

FUNCTION FormatFontSize(fontsize binary_integer) return binary_integer IS
BEGIN
	ORDCOM.InitArg();
	ORDCOM.SetArg(fontsize, 'I4');
	i:=ORDCOM.Invoke(applicationToken, 'FormatFont', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END FormatFontSize;


FUNCTION InsertText(textstr varchar2) return binary_integer IS
BEGIN 
	ORDCOM.InitArg();
	ORDCOM.SetArg(textstr,'BSTR');
	i:=ORDCOM.Invoke(applicationToken, 'Insert', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END InsertText;

FUNCTION InsertNewLine return binary_integer IS
BEGIN 
	ORDCOM.InitArg();
	i:=ORDCOM.Invoke(applicationToken, 'InsertPara', 0, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END InsertNewLine;

FUNCTION FileSaveAs(filename varchar2) return binary_integer IS
BEGIN
	dbms_output.put_line('Saving file....');
	ORDCOM.InitArg();
	ORDCOM.SetArg(filename,'BSTR');
	i:=ORDCOM.Invoke(applicationToken, 'FileSaveAs', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END FileSaveAs;

FUNCTION FileSave return binary_integer IS
BEGIN
	dbms_output.put_line('Saving file....');
	ORDCOM.InitArg();
	i:=ORDCOM.Invoke(applicationToken, 'FileSave', 0, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	return i;
END FileSave;

FUNCTION FileClose return binary_integer IS
BEGIN
	dbms_output.put_line('Closing file...');
	ORDCOM.InitArg();
	ORDCOM.InitArg();
	ORDCOM.SetArg(2,'I2');
	i:=ORDCOM.Invoke(applicationToken, 'FileClose', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	ORDCOM.InitArg();
	ORDCOM.InitArg();
	ORDCOM.SetArg(1,'I2');
	i:=ORDCOM.Invoke(applicationToken, 'FileExit', 1, DummyToken);
	IF (i!=0) THEN	
	ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
	dbms_output.put_line(error_src);
	dbms_output.put_line(error_description);
	dbms_output.put_line(error_helpfile);
	END IF;
	i:=ORDCOM.DestroyObject(applicationToken);
	return i;
END FileClose;

END ORDWord;